-- MariaDB dump 10.19  Distrib 10.6.16-MariaDB, for Linux (x86_64)
--
-- Host: db    Database: homestead
-- ------------------------------------------------------
-- Server version	5.6.51

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `abilities`
--

DROP TABLE IF EXISTS `abilities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `abilities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entity_id` int(10) unsigned DEFAULT NULL,
  `entity_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `only_owned` tinyint(1) NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_ci,
  `scope` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `abilities_scope_index` (`scope`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abilities`
--

LOCK TABLES `abilities` WRITE;
/*!40000 ALTER TABLE `abilities` DISABLE KEYS */;
INSERT INTO `abilities` VALUES (1,'game-server-common','Common Game Server Ability',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(2,'game-server-start','Start Game Server',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(3,'game-server-stop','Stop Game Server',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(4,'game-server-restart','Restart Server',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(5,'game-server-pause','Pause Game Server',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(6,'game-server-update','Update Game Server',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(7,'game-server-console-view','Access to read server console',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(8,'game-server-console-send','Access to send console commands',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(9,'game-server-files','Access to server filemanager',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(10,'game-server-settings','Access to server settings',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(11,'game-server-common','Game server common',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(12,'game-server-start','Game server start',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(13,'game-server-stop','Game server stop',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(14,'game-server-restart','Game server restart',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(15,'game-server-pause','Game server pause',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(16,'game-server-update','Game server update',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(17,'game-server-console-view','Game server console view',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(18,'game-server-console-send','Game server console send',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(19,'game-server-files','Game server files',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(20,'game-server-settings','Game server settings',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(21,'create','Create New Item Permission',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(22,'view','View Items Permission',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(23,'edit','Edit Items Permission',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(24,'delete','Delete Items Permission',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(25,'admin roles & permissions','Common Admininstator Permissions',NULL,NULL,0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(26,'create','Create servers',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(27,'view','View servers',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(28,'edit','Edit servers',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(29,'delete','Delete servers',NULL,'Gameap\\Models\\Server',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(30,'create','Create client certificates',NULL,'Gameap\\Models\\ClientCertificate',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(31,'view','View client certificates',NULL,'Gameap\\Models\\ClientCertificate',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(32,'edit','Edit client certificates',NULL,'Gameap\\Models\\ClientCertificate',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(33,'delete','Delete client certificates',NULL,'Gameap\\Models\\ClientCertificate',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(34,'create','Create dedicated servers',NULL,'Gameap\\Models\\DedicatedServer',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(35,'view','View dedicated servers',NULL,'Gameap\\Models\\DedicatedServer',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(36,'edit','Edit dedicated servers',NULL,'Gameap\\Models\\DedicatedServer',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(37,'delete','Delete dedicated servers',NULL,'Gameap\\Models\\DedicatedServer',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(38,'create','Create games',NULL,'Gameap\\Models\\Game',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(39,'view','View games',NULL,'Gameap\\Models\\Game',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(40,'edit','Edit games',NULL,'Gameap\\Models\\Game',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(41,'delete','Delete games',NULL,'Gameap\\Models\\Game',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(42,'create','Create game mods',NULL,'Gameap\\Models\\GameMod',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(43,'view','View game mods',NULL,'Gameap\\Models\\GameMod',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(44,'edit','Edit game mods',NULL,'Gameap\\Models\\GameMod',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(45,'delete','Delete game mods',NULL,'Gameap\\Models\\GameMod',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(46,'create','Create users',NULL,'Gameap\\Models\\User',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(47,'view','View users',NULL,'Gameap\\Models\\User',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(48,'edit','Edit users',NULL,'Gameap\\Models\\User',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(49,'delete','Delete users',NULL,'Gameap\\Models\\User',0,NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55');
/*!40000 ALTER TABLE `abilities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assigned_roles`
--

DROP TABLE IF EXISTS `assigned_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assigned_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `entity_id` int(10) unsigned NOT NULL,
  `entity_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `restricted_to_id` int(10) unsigned DEFAULT NULL,
  `restricted_to_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scope` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assigned_roles_entity_index` (`entity_id`,`entity_type`,`scope`),
  KEY `assigned_roles_role_id_index` (`role_id`),
  KEY `assigned_roles_scope_index` (`scope`),
  CONSTRAINT `assigned_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assigned_roles`
--

LOCK TABLES `assigned_roles` WRITE;
/*!40000 ALTER TABLE `assigned_roles` DISABLE KEYS */;
INSERT INTO `assigned_roles` VALUES (1,1,1,'Gameap\\Models\\User',NULL,NULL,NULL),(2,2,1,'Gameap\\Models\\User',NULL,NULL,NULL);
/*!40000 ALTER TABLE `assigned_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `client_certificates`
--

DROP TABLE IF EXISTS `client_certificates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `client_certificates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fingerprint` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expires` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `certificate` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `private_key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `private_key_pass` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `client_certificates`
--

LOCK TABLES `client_certificates` WRITE;
/*!40000 ALTER TABLE `client_certificates` DISABLE KEYS */;
INSERT INTO `client_certificates` VALUES (1,'85:EA:4A:99:69:5E:5E:39:C4:8E:C4:27:9B:1C:D2:E8:F7:1D:80:C6:1D:F0:8D:A5:04:34:66:D5:0D:53:41:42','2034-03-02 12:20:55','certs/client/client_1709382053.crt','certs/client/client_1709382053.key','');
/*!40000 ALTER TABLE `client_certificates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dedicated_servers`
--

DROP TABLE IF EXISTS `dedicated_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dedicated_servers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `os` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'linux',
  `location` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ram` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cpu` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `work_path` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `steamcmd_path` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gdaemon_host` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gdaemon_port` int(10) unsigned NOT NULL DEFAULT '31717',
  `gdaemon_api_key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gdaemon_api_token` char(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gdaemon_login` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gdaemon_password` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gdaemon_server_cert` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_certificate_id` int(10) unsigned NOT NULL,
  `prefer_install_method` enum('auto','copy','download','script','steam','none') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'auto',
  `script_install` text COLLATE utf8mb4_unicode_ci,
  `script_reinstall` text COLLATE utf8mb4_unicode_ci,
  `script_update` text COLLATE utf8mb4_unicode_ci,
  `script_start` text COLLATE utf8mb4_unicode_ci,
  `script_pause` text COLLATE utf8mb4_unicode_ci,
  `script_unpause` text COLLATE utf8mb4_unicode_ci,
  `script_stop` text COLLATE utf8mb4_unicode_ci,
  `script_kill` text COLLATE utf8mb4_unicode_ci,
  `script_restart` text COLLATE utf8mb4_unicode_ci,
  `script_status` text COLLATE utf8mb4_unicode_ci,
  `script_stats` text COLLATE utf8mb4_unicode_ci,
  `script_get_console` text COLLATE utf8mb4_unicode_ci,
  `script_send_command` text COLLATE utf8mb4_unicode_ci,
  `script_delete` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dedicated_servers`
--

LOCK TABLES `dedicated_servers` WRITE;
/*!40000 ALTER TABLE `dedicated_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `dedicated_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ds_stats`
--

DROP TABLE IF EXISTS `ds_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ds_stats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dedicated_server_id` int(10) unsigned NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `loa` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ram` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cpu` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ifstat` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ping` int(10) unsigned NOT NULL,
  `drvspace` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ds_stats_dedicated_server_id_foreign` (`dedicated_server_id`),
  CONSTRAINT `ds_stats_dedicated_server_id_foreign` FOREIGN KEY (`dedicated_server_id`) REFERENCES `dedicated_servers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ds_stats`
--

LOCK TABLES `ds_stats` WRITE;
/*!40000 ALTER TABLE `ds_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `ds_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ds_users`
--

DROP TABLE IF EXISTS `ds_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ds_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dedicated_server_id` int(10) unsigned NOT NULL,
  `username` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `gid` int(10) unsigned NOT NULL,
  `password` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ds_users_dedicated_server_id_foreign` (`dedicated_server_id`),
  CONSTRAINT `ds_users_dedicated_server_id_foreign` FOREIGN KEY (`dedicated_server_id`) REFERENCES `dedicated_servers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ds_users`
--

LOCK TABLES `ds_users` WRITE;
/*!40000 ALTER TABLE `ds_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `ds_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `game_mods`
--

DROP TABLE IF EXISTS `game_mods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `game_mods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `game_code` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fast_rcon` text COLLATE utf8mb4_unicode_ci,
  `vars` text COLLATE utf8mb4_unicode_ci,
  `remote_repository_linux` text COLLATE utf8mb4_unicode_ci,
  `remote_repository_windows` text COLLATE utf8mb4_unicode_ci,
  `local_repository_linux` text COLLATE utf8mb4_unicode_ci,
  `local_repository_windows` text COLLATE utf8mb4_unicode_ci,
  `start_cmd_linux` text COLLATE utf8mb4_unicode_ci,
  `start_cmd_windows` text COLLATE utf8mb4_unicode_ci,
  `kick_cmd` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ban_cmd` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `chname_cmd` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `srestart_cmd` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `chmap_cmd` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sendmsg_cmd` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `passwd_cmd` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `game_mods_game_code_foreign` (`game_code`),
  CONSTRAINT `game_mods_game_code_foreign` FOREIGN KEY (`game_code`) REFERENCES `games` (`code`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `game_mods`
--

LOCK TABLES `game_mods` WRITE;
/*!40000 ALTER TABLE `game_mods` DISABLE KEYS */;
INSERT INTO `game_mods` VALUES (1,'valve','Default','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"}]','[{\"var\":\"default_map\",\"default\":\"crossfire\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./hlds_run -console -game valve +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','hlds.exe -console -game valve +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(2,'valve','Classic (AMX Mod)','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"},{\"info\":\"Last disconnect players\",\"command\":\"amx_last\"},{\"info\":\"Admins on servers\",\"command\":\"amx_who\"}]','[{\"var\":\"default_map\",\"default\":\"crossfire\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]','http://files.gameap.ru/half-life/amxx.tar.xz','http://files.gameap.ru/half-life/amxx.tar.xz',NULL,NULL,'./hlds_run -console -game valve +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','hlds.exe -console -game valve +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}','amx_ban \"{name}\" {time} \"{reason}\"','amx_nick #{id} {name}','restart','changelevel {map}','amx_say \"{msg}\"','password {password}'),(3,'valve','Classic (ReHLDS)','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"}]','[{\"var\":\"default_map\",\"default\":\"crossfire\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]','http://files.gameap.ru/half-life/rehlds-amxx-reunion.tar.xz','http://files.gameap.ru/half-life/rehlds-amxx-reunion.tar.xz',NULL,NULL,'./hlds_run -console -game valve +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','hlds.exe -console -game valve +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(4,'op4','Default','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"}]','[{\"var\":\"default_map\",\"default\":\"crossfire\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./hlds_run -console -game valve +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','hlds.exe -console -game valve +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(5,'hl2mp','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"crossfire\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(6,'bms','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"crossfire\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game bms +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game bms +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(7,'cstrike','Default','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"}]','[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./hlds_run -console -game cstrike +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','hlds.exe -console -game cstrike +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(8,'cstrike','Classic (AMX Mod)','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"},{\"info\":\"Last disconnect players\",\"command\":\"amx_last\"},{\"info\":\"Admins on servers\",\"command\":\"amx_who\"}]','[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]','http://files.gameap.ru/cstrike-1.6/amxx.tar.xz','http://files.gameap.ru/cstrike-1.6/amxx.tar.xz',NULL,NULL,'./hlds_run -console -game cstrike +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','hlds.exe -console -game cstrike +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}','amx_ban \"{name}\" {time} \"{reason}\"','amx_nick #{id} {name}','restart','changelevel {map}','amx_say \"{msg}\"','password {password}'),(9,'cstrike','Classic (ReHLDS)','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"}]','[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]','http://files.gameap.ru/cstrike-1.6/rehlds-amxx-reunion.tar.xz','http://files.gameap.ru/cstrike-1.6/rehlds-amxx-reunion.tar.xz',NULL,NULL,'./hlds_run -console -game cstrike +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','hlds.exe -console -game cstrike +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(10,'czero','Default','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"}]','[{\"var\":\"default_map\",\"default\":\"de_dust\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./hlds_run -console -game czero +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','hlds.exe -console -game czero +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(11,'cssv34','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game cstrike +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game cstrike +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(12,'cssource','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game cstrike +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game cstrike +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(13,'csgo','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true},{\"var\":\"mapgroup\",\"default\":\"mg_active\",\"info\":\"Map group\"},{\"var\":\"steamaccount\",\"default\":\"\",\"info\":\"Steam account token\"}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 0 +game_mode 0','srcds.exe -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 0 +game_mode 0','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(14,'csgo','Competitive',NULL,'[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true},{\"var\":\"mapgroup\",\"default\":\"mg_active\",\"info\":\"Map group\"},{\"var\":\"steamaccount\",\"default\":\"\",\"info\":\"Steam account token\"}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 0 +game_mode 1','srcds.exe -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 0 +game_mode 1','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(15,'csgo','Gungame',NULL,'[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true},{\"var\":\"mapgroup\",\"default\":\"mg_active\",\"info\":\"Map group\"},{\"var\":\"steamaccount\",\"default\":\"\",\"info\":\"Steam account token\"}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 1 +game_mode 0','srcds.exe -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 1 +game_mode 0','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(16,'csgo','Demolition',NULL,'[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true},{\"var\":\"mapgroup\",\"default\":\"mg_active\",\"info\":\"Map group\"},{\"var\":\"steamaccount\",\"default\":\"\",\"info\":\"Steam account token\"}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 1 +game_mode 1','srcds.exe -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 1 +game_mode 1','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(17,'csgo','Deathmatch',NULL,'[{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true},{\"var\":\"mapgroup\",\"default\":\"mg_active\",\"info\":\"Map group\"},{\"var\":\"steamaccount\",\"default\":\"\",\"info\":\"Steam account token\"}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 1 +game_mode 2','srcds.exe -console -game csgo +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password} +sv_setsteamaccount {steamaccount} +mapgroup {mapgroup} +game_type 1 +game_mode 2','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(18,'cs2','Default',NULL,'[{\"var\":\"hostname\",\"default\":\"[GameAP] New CS2 Server\",\"info\":\"Hostname\"},{\"var\":\"default_map\",\"default\":\"de_dust2\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":64,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"mapgroup\",\"default\":\"mg_active\",\"info\":\"Map group\"},{\"var\":\"steamaccount\",\"default\":\"\",\"info\":\"Steam account token\"}]',NULL,NULL,NULL,NULL,'./cs2 -dedicated -ip {ip} -port {port} -maxplayers {maxplayers} +hostname {hostname} +map {default_map} +sv_setsteamaccount {steamaccount}','cs2.exe -dedicated -ip {ip} -port {port} -maxplayers {maxplayers} +hostname {hostname} +map {default_map} +sv_setsteamaccount {steamaccount}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(19,'tfc','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"2fort\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game tfc +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game tfc +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(20,'tf2','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"ctf_2fort\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game tf +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game tf +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(21,'dod','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"dod_anzio\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game dod +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game dod +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(22,'dods','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"dod_anzio\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game dods +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game dods +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(23,'l4d','Default','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"}]','[{\"var\":\"default_map\",\"default\":\"l4d_farm04_barn\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./hlds_run -console -game left4dead +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','hlds.exe -console -game left4dead +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(24,'l4d2','Default','[{\"info\":\"Status\",\"command\":\"status\"},{\"info\":\"Stats\",\"command\":\"stats\"}]','[{\"var\":\"default_map\",\"default\":\"c2m1_highway\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game left4dead2 +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game left4dead2 +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(25,'dmc','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(26,'ricochet','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(27,'svencoop','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"stadium4\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"fps\",\"default\":500,\"info\":\"Server FPS (tickrate)\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./svends_run -console +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','svends.exe -console +ip {ip} +port {port} +map {default_map} +maxplayers {maxplayers} +sys_ticrate {fps} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(28,'insurgency','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"ministry\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(29,'garrysmod','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"gm_construct\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game garrysmod +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game garrysmod +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(30,'nmrih','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(31,'pvk2','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(32,'synergy','Default',NULL,'[{\"var\":\"default_map\",\"default\":\"d1_trainstation_01\",\"info\":\"Default Map\"},{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\",\"admin_var\":true},{\"var\":\"tickrate\",\"default\":64,\"info\":\"Server tickrate\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,'./srcds_run -console -game synergy +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','srcds.exe -console -game synergy +ip {ip} +port {port} +maxplayers {maxplayers} +map {default_map} -tickrate {tickrate} +rcon_password {rcon_password}','kick #{id}',NULL,NULL,'restart','changelevel {map}','say \"{msg}\"','password {password}'),(33,'minecraft','Multicore',NULL,'[{\"var\":\"version\",\"default\":\"1.14.3\",\"info\":\"Minecraft version\"},{\"var\":\"core_mod\",\"default\":\"vanilla\",\"info\":\"Core\"},{\"var\":\"core_mod_version\",\"default\":null,\"info\":\"Core mod version\"}]','http://files.gameap.ru/minecraft/minecraft-runner.tar.gz','http://files.gameap.ru/minecraft/minecraft-runner.tar.gz',NULL,NULL,'./mcrun.sh run --version={version} --core-mod={core_mod} --core-mod-version={core_mod_version} --ip={ip} --port={port} --query-port={query_port} --rcon-port={rcon_port} --rcon-password={rcon_password}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(34,'minecraft','Default',NULL,'[{\"var\":\"world\",\"default\":\"world\",\"info\":\"World file\"},{\"var\":\"java_xms\",\"default\":\"1G\",\"info\":\"Java start RAM amount\",\"admin_var\":true},{\"var\":\"java_xmx\",\"default\":\"2G\",\"info\":\"Java max RAM amount\",\"admin_var\":true}]','https://launcher.mojang.com/v1/objects/c8f83c5655308435b3dcf03c06d9fe8740a77469/server.jar','https://launcher.mojang.com/v1/objects/c8f83c5655308435b3dcf03c06d9fe8740a77469/server.jar',NULL,NULL,'java -Xms{java_xms} -Xmx{java_xms} -jar server.jar --port {port} --world {world} --nogui','java -Xms{java_xms} -Xmx{java_xms} -jar server.jar --port {port} --world {world} --nogui',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(35,'pmmp','PocketMine-MP',NULL,NULL,'https://github.com/pmmp/PocketMine-MP/releases/download/4.2.7/PocketMine-MP.phar','https://github.com/pmmp/PocketMine-MP/releases/download/4.2.7/PocketMine-MP.phar',NULL,NULL,'./bin/php7/bin/php ./PocketMine-MP.phar','','kick {name}','ban {name} {reason}',NULL,'reload',NULL,'say {msg}','password {password}'),(36,'samp','Default (Freeroam)',NULL,NULL,'http://files.sa-mp.com/samp037svr_R2-1.tar.gz','http://files.sa-mp.com/samp037_svr_R2-1-1_win32.zip',NULL,NULL,'./samp03svr','samp-server.exe',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(37,'mta','DeathMatch',NULL,'[{\"var\":\"maxplayers\",\"default\":32,\"info\":\"Maximum players on server\"}]','http://files.gameap.ru/mta/default-deathmatch.tar.xz','http://files.gameap.ru/mta/default-deathmatch.tar.xz',NULL,NULL,'./mta-server64 -t -n --ip {ip} --port {port} --maxplayers {maxplayers}','',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(38,'fivem','Default',NULL,'[{\"var\":\"hostname\",\"default\":\"GameAP FiveM Server\",\"info\":\"Server Hostname\"},{\"var\":\"license_key\",\"default\":\"changeme\",\"info\":\"License key from https:\\/\\/keymaster.fivem.net\",\"admin_var\":true}]','http://files.gameap.ru/fivem/fivem.tar.xz','http://files.gameap.ru/fivem/fivem.tar.xz',NULL,NULL,'./fivem_run.sh --ip={ip} --port={port} --hostname=\"{hostname}\" --rcon-password=\"{rcon_password}\" --license-key=\"{license_key}\"','run.cmd +exec server.cfg','clientkick {id}',NULL,NULL,NULL,NULL,'say {msg}',NULL),(39,'ragemp','Default',NULL,NULL,'https://cdn.rage.mp/updater/prerelease/server-files/linux_x64.tar.gz','',NULL,NULL,'./ragemp-server','',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(40,'justcause2','Default',NULL,NULL,NULL,NULL,NULL,NULL,'./Jcmp-Server','',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(41,'justcause3','Default',NULL,NULL,NULL,NULL,NULL,NULL,'./Server','',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(42,'arma2','Default',NULL,'[{\"var\":\"server_name\",\"default\":\"Arma 2 server\",\"info\":\"Server name\"},{\"var\":\"config_file\",\"default\":\"server.cfg\",\"info\":\"Config file name\"}]',NULL,NULL,NULL,NULL,'./arma2server -name={server_name} -config={config_file}','',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(43,'arma2oa','Default',NULL,'[{\"var\":\"server_name\",\"default\":\"Arma 2 server\",\"info\":\"Server name\"},{\"var\":\"config_file\",\"default\":\"server.cfg\",\"info\":\"Config file name\"}]',NULL,NULL,NULL,NULL,'./arma2server -name={server_name} -config={config_file}','',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(44,'arma3','Default',NULL,'[{\"var\":\"server_name\",\"default\":\"Arma 2 server\",\"info\":\"Server name\"},{\"var\":\"config_file\",\"default\":\"server.cfg\",\"info\":\"Config file name\"}]',NULL,NULL,NULL,NULL,'./arma3server -name={server_name} -config={config_file}','',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(45,'killingfloor2','Default',NULL,'{\"var\":\"default_map\",\"default\":\"kf-bioticslab\",\"info\":\"Default Map\"}',NULL,NULL,NULL,NULL,'./Binaries/Win64/KFGameSteamServer.bin.x86_64 {default_map}','Binaries\\win64\\kfserver {default_map}',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(46,'ark','Default',NULL,'[{\"var\":\"server_password\",\"default\":\"\",\"info\":\"Server password\"},{\"var\":\"session_name\",\"default\":\"ARK server\",\"info\":\"Session name\"}]',NULL,NULL,NULL,NULL,'./ShooterGameServer TheIsland?listen?SessionName={session_name}?Port={port}?QueryPort={query_port}?MaxPlayers={maxplayers}?ServerPassword={server_password}?ServerAdminPassword={rcon_password} -server -log','ShooterGameServer.exe TheIsland?listen?SessionName={session_name}?Port={port}?QueryPort={query_port}?MaxPlayers={maxplayers}?ServerPassword={server_password}?ServerAdminPassword={rcon_password} exit',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(47,'hurtworld','Default',NULL,'[{\"var\":\"server_name\",\"default\":\"HurtWorld server\",\"info\":\"Server name\"},{\"var\":\"admin_uid\",\"default\":\"\",\"info\":\"Admin UID\"},{\"var\":\"log_file\",\"default\":\"gamelog.txt\",\"info\":\"Log file name\"}]',NULL,NULL,NULL,NULL,'','Hurtworld.exe -batchmode -nographics -exec \"host {port};queryport {query_port};servername {server_name};addadmin admin_uid\" -logfile \"{log_file}\"',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(48,'rust','Vanilla',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(49,'rust','Oxide',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(50,'rok','Default',NULL,NULL,NULL,NULL,NULL,NULL,'','',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(51,'7d2d','Default',NULL,NULL,NULL,NULL,NULL,NULL,'./startserver.sh -configfile=serverconfig.xml','startdedicated.bat',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(52,'dst','Default',NULL,NULL,'https://files.gameap.ru/dont-starve-together/default-mod.tar.gz',NULL,NULL,NULL,'./run.sh','',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(53,'the-forest','Default',NULL,'[{\"var\":\"name\",\"default\":\"The forest dedicated server\",\"info\":\"Server name\"},{\"var\":\"password\",\"default\":\"\",\"info\":\"Server password\"},{\"var\":\"password_admin\",\"default\":\"\",\"info\":\"Server admin password\"},{\"var\":\"serversteamaccount\",\"default\":\"\",\"info\":\"Server steam account\"},{\"var\":\"enableVAC\",\"default\":\"on\",\"info\":\"Enable VAC?\"},{\"var\":\"serverautosaveinterval\",\"default\":\"15\",\"info\":\"Autosave interval\"},{\"var\":\"difficulty\",\"default\":\"Normal\",\"info\":\"Difficulty\"},{\"var\":\"slot\",\"default\":\"1\",\"info\":\"slot\"},{\"var\":\"maxplayers\",\"default\":\"8\",\"info\":\"Max players\",\"admin_var\":true},{\"var\":\"steamport\",\"default\":\"8766\",\"info\":\"Server steamport\",\"admin_var\":true}]',NULL,NULL,NULL,NULL,NULL,'TheForestDedicatedServer.exe -serverip {ip} -servergameport {port} -serverqueryport {query_port} -serversteamport {steamport} -serverplayers {maxplayers} -servername \"{servername}\" -serverpassword {password} -serverpassword_admin {password_admin} -enableVAC {enableVAC} -serverautosaveinterval {serverautosaveinterval} -difficulty {difficulty} -slot {slot} ',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(54,'teeworlds','Default',NULL,NULL,'https://github.com/teeworlds/teeworlds/releases/download/0.7.5/teeworlds-0.7.5-linux_x86_64.tar.gz','https://github.com/teeworlds/teeworlds/releases/download/0.7.5/teeworlds-0.7.5-win64.zip',NULL,NULL,'./teeworlds-0.7.5-linux_x86_64/teeworlds_srv -f server.cfg','teeworlds-0.7.5-win64\\teeworlds_srv.exe -f server.cfg',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(55,'teeworlds','DDrace',NULL,NULL,'https://ddnet.tw/downloads/DDNet-16.0.3-linux_x86_64.tar.xz','https://ddnet.tw/downloads/DDNet-16.0.3-win64.zip',NULL,NULL,'./DDNet-16.0.3-linux_x86_64/DDNet-Server -f server.cfg','DDNet-16.0.3-win64\\DDNet-Server.exe -f server.cfg',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `game_mods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `games`
--

DROP TABLE IF EXISTS `games`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `games` (
  `code` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `engine` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `engine_version` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.0',
  `steam_app_id_linux` int(10) unsigned DEFAULT NULL,
  `steam_app_id_windows` int(10) unsigned DEFAULT NULL,
  `steam_app_set_config` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remote_repository_linux` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remote_repository_windows` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `local_repository_linux` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `local_repository_windows` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  UNIQUE KEY `games_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `games`
--

LOCK TABLES `games` WRITE;
/*!40000 ALTER TABLE `games` DISABLE KEYS */;
INSERT INTO `games` VALUES ('7d2d','7 Days to Die','Unity','1.0',294420,294420,NULL,NULL,NULL,NULL,NULL,1),('ark','ARK: Survival Evolved','Unreal Engine','4',376030,376030,NULL,NULL,NULL,NULL,NULL,1),('arma2','Arma 2','armedassault2','3',NULL,33905,NULL,NULL,NULL,NULL,NULL,1),('arma2oa','Arma 2: Operation Arrowhead','armedassault2oa','3',NULL,33935,NULL,NULL,NULL,NULL,NULL,1),('arma3','Arma 3','armedassault3','4',233780,233780,NULL,NULL,NULL,NULL,NULL,1),('bms','Black Mesa: Deathmatch','source','4',346680,346680,NULL,NULL,NULL,NULL,NULL,1),('cod3','Call of Duty 3','cod4','1.0',NULL,42750,NULL,NULL,NULL,NULL,NULL,1),('cod4','Call of Duty 4','cod4','3.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1),('cs15','Counter-Strike 1.5','goldsource','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1),('cs2','Counter-Strike 2','source','2',730,730,NULL,NULL,NULL,NULL,NULL,1),('csgo','Counter-Strike: Global Offensive','source','1',740,740,NULL,NULL,NULL,NULL,NULL,1),('cssource','Counter-Strike: Source','source','1',232330,232330,NULL,NULL,NULL,NULL,NULL,1),('cssv34','Counter-Strike: Source v34','source','34',232330,232330,NULL,NULL,NULL,NULL,NULL,1),('cstrike','Counter-Strike 1.6','goldsource','1',90,90,NULL,'http://files.gameap.ru/cstrike-1.6/hlcs_base.tar.xz',NULL,NULL,NULL,1),('czero','Counter-Strike: Condition Zero','goldsource','1',90,90,'90 mod czero',NULL,NULL,NULL,NULL,1),('dmc','Deathmatch Classic','goldsource','1',90,90,'90 mod dmc',NULL,NULL,NULL,NULL,1),('dod','Day of Defeat','goldsource','1',90,90,'90 mod dod',NULL,NULL,NULL,NULL,1),('dods','Day of Defeat: Source','source','1',232290,232290,NULL,NULL,NULL,NULL,NULL,1),('dst','Don\'t Starve Together','Don\'t Starve','1',343050,343050,NULL,NULL,NULL,NULL,NULL,1),('fivem','FiveM','Gta5m','1.0',NULL,NULL,NULL,'http://files.gameap.ru/fivem/fivem.tar.xz',NULL,NULL,NULL,1),('garrysmod','Garry`s Mod','source','1',4020,4020,NULL,NULL,NULL,NULL,NULL,1),('hl2mp','Half-Life 2','source','1',232370,232370,NULL,NULL,NULL,NULL,NULL,1),('hurtworld','HurtWorld','Unity','1.0',405100,405100,NULL,NULL,NULL,NULL,NULL,1),('insurgency','Insurgency','source','1',237410,237410,NULL,NULL,NULL,NULL,NULL,1),('justcause2','Just Cause 2','AvalancheEngine','2.0',261140,261140,NULL,NULL,NULL,NULL,NULL,1),('justcause3','Just Cause 3','AvalancheEngine','3.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1),('killingfloor2','Killing Floor 2','UnrealEngine','3',232130,232130,NULL,NULL,NULL,NULL,NULL,1),('l4d','Left 4 Dead','source','1',222840,222840,NULL,NULL,NULL,NULL,NULL,1),('l4d2','Left 4 Dead 2','source','1',222860,222860,NULL,NULL,NULL,NULL,NULL,1),('minecraft','Minecraft','minecraft','1.0',NULL,NULL,NULL,'http://files.gameap.ru/minecraft/minecraft_install.tar.gz',NULL,NULL,NULL,1),('mta','GTA: Multi Theft Auto','mta','1.0',NULL,NULL,NULL,'http://files.gameap.ru/mta/mta.tar.xz',NULL,NULL,NULL,1),('nmrih','No More Room In Hell','source','1',317670,317670,NULL,NULL,NULL,NULL,NULL,1),('op4','Half-Life: Opposing Force','goldsource','1',90,90,'90 mod gearbox',NULL,NULL,NULL,NULL,1),('pmmp','PocketMineMP (Minecraft PE)','minecraft','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1),('pvk2','Pirates, Vikings, and Knights II','source','1',17575,17575,NULL,NULL,NULL,NULL,NULL,1),('ragemp','RageMP','Rage','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1),('ricochet','Ricochet','goldsource','1',90,90,'90 mod ricochet',NULL,NULL,NULL,NULL,1),('rok','Reign Of Kings','Unity','1.0',NULL,344760,NULL,NULL,NULL,NULL,NULL,1),('rust','Rust','Unity','1.0',NULL,258550,NULL,NULL,NULL,NULL,NULL,1),('samp','SA-MP','samp','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1),('svencoop','Sven Co-op','goldsource','1',276060,276060,NULL,NULL,NULL,NULL,NULL,1),('synergy','Synergy','source','1',17525,17525,NULL,NULL,NULL,NULL,NULL,1),('teeworlds','Teeworlds','Teeworlds','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1),('tf2','Team Fortress 2','source','1',232250,232250,NULL,NULL,NULL,NULL,NULL,1),('tfc','Team Fortress Classic','goldsource','1',90,90,'90 mod tfc',NULL,NULL,NULL,NULL,1),('the-forest','The Forest','Unity','1.0',NULL,556450,NULL,NULL,NULL,NULL,NULL,1),('valve','Half-Life 1','goldsource','1',90,90,NULL,NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `games` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gdaemon_tasks`
--

DROP TABLE IF EXISTS `gdaemon_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gdaemon_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `run_aft_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `dedicated_server_id` int(10) unsigned NOT NULL,
  `server_id` int(10) unsigned DEFAULT NULL,
  `task` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` mediumtext COLLATE utf8mb4_unicode_ci,
  `cmd` text COLLATE utf8mb4_unicode_ci,
  `output` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` enum('waiting','working','error','success','canceled') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gdaemon_tasks`
--

LOCK TABLES `gdaemon_tasks` WRITE;
/*!40000 ALTER TABLE `gdaemon_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `gdaemon_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2017_09_12_000000_create_dedicated_servers_table',1),(4,'2017_09_12_100000_create_ds_stats_table',1),(5,'2017_09_12_200000_create_ds_users_table',1),(6,'2017_09_12_300000_create_games_table',1),(7,'2017_09_12_400000_create_game_mods_table',1),(8,'2017_09_12_500000_create_gdaemon_tasks_table',1),(9,'2017_09_12_600000_create_servers_table',1),(10,'2017_09_12_700000_create_servers_settings_table',1),(11,'2017_09_12_800000_create_servers_stats_table',1),(12,'2017_10_15_163730_create_permission_tables',1),(13,'2018_12_04_143042_create_client_certificates',1),(14,'2018_12_07_143515_create_server_user',1),(15,'2019_03_18_154345_create_jobs_table',1),(16,'2019_07_01_144304_add_gdaemon_task_canceled_status',1),(17,'2019_07_10_183954_add_foreign_keys',1),(18,'2019_07_10_205811_add_servers_deleted_at',1),(19,'2019_10_06_192224_add_gdaemon_tasks_server_id_nullable',1),(20,'2019_12_14_000001_create_personal_access_tokens_table',1),(21,'2020_01_22_212705_create_bouncer_tables',1),(22,'2020_03_04_182805_create_servers_tasks_table',1),(23,'2020_03_04_195038_create_servers_tasks_fails_table',1),(24,'2022_06_13_191501_change_games_table',1),(25,'2022_06_13_191643_change_game_mods_table',1),(26,'2023_02_27_125000_add_games_enabled',1),(27,'2023_02_27_152300_remove_games_start_code',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ability_id` int(10) unsigned NOT NULL,
  `entity_id` int(10) unsigned DEFAULT NULL,
  `entity_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forbidden` tinyint(1) NOT NULL DEFAULT '0',
  `scope` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `permissions_entity_index` (`entity_id`,`entity_type`,`scope`),
  KEY `permissions_ability_id_index` (`ability_id`),
  KEY `permissions_scope_index` (`scope`),
  CONSTRAINT `permissions_ability_id_foreign` FOREIGN KEY (`ability_id`) REFERENCES `abilities` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,1,2,'roles',0,NULL),(2,2,2,'roles',0,NULL),(3,3,2,'roles',0,NULL),(4,4,2,'roles',0,NULL),(5,5,2,'roles',0,NULL),(6,6,2,'roles',0,NULL),(7,7,2,'roles',0,NULL),(8,8,2,'roles',0,NULL),(9,9,2,'roles',0,NULL),(10,10,2,'roles',0,NULL),(11,11,1,'roles',0,NULL),(12,12,1,'roles',0,NULL),(13,13,1,'roles',0,NULL),(14,14,1,'roles',0,NULL),(15,15,1,'roles',0,NULL),(16,16,1,'roles',0,NULL),(17,17,1,'roles',0,NULL),(18,18,1,'roles',0,NULL),(19,19,1,'roles',0,NULL),(20,20,1,'roles',0,NULL),(21,25,1,'roles',0,NULL),(22,21,1,'roles',0,NULL),(23,22,1,'roles',0,NULL),(24,23,1,'roles',0,NULL),(25,24,1,'roles',0,NULL),(26,26,1,'roles',0,NULL),(27,27,1,'roles',0,NULL),(28,28,1,'roles',0,NULL),(29,29,1,'roles',0,NULL),(30,30,1,'roles',0,NULL),(31,31,1,'roles',0,NULL),(32,32,1,'roles',0,NULL),(33,33,1,'roles',0,NULL),(34,34,1,'roles',0,NULL),(35,35,1,'roles',0,NULL),(36,36,1,'roles',0,NULL),(37,37,1,'roles',0,NULL),(38,38,1,'roles',0,NULL),(39,39,1,'roles',0,NULL),(40,40,1,'roles',0,NULL),(41,41,1,'roles',0,NULL),(42,42,1,'roles',0,NULL),(43,43,1,'roles',0,NULL),(44,44,1,'roles',0,NULL),(45,45,1,'roles',0,NULL),(46,46,1,'roles',0,NULL),(47,47,1,'roles',0,NULL),(48,48,1,'roles',0,NULL),(49,49,1,'roles',0,NULL);
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `level` int(10) unsigned DEFAULT NULL,
  `scope` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_unique` (`name`,`scope`),
  KEY `roles_scope_index` (`scope`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Administrator',NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55'),(2,'user','User',NULL,NULL,'2024-03-02 12:20:55','2024-03-02 12:20:55');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `server_user`
--

DROP TABLE IF EXISTS `server_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `server_user` (
  `server_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  KEY `server_user_server_id_foreign` (`server_id`),
  KEY `server_user_user_id_foreign` (`user_id`),
  CONSTRAINT `server_user_server_id_foreign` FOREIGN KEY (`server_id`) REFERENCES `servers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `server_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `server_user`
--

LOCK TABLES `server_user` WRITE;
/*!40000 ALTER TABLE `server_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `server_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servers`
--

DROP TABLE IF EXISTS `servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `servers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uuid_short` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  `installed` int(11) NOT NULL DEFAULT '0',
  `blocked` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `game_id` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ds_id` int(10) unsigned NOT NULL,
  `game_mod_id` int(10) unsigned NOT NULL,
  `expires` timestamp NULL DEFAULT NULL,
  `server_ip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `server_port` int(10) unsigned NOT NULL,
  `query_port` int(10) unsigned DEFAULT NULL,
  `rcon_port` int(10) unsigned DEFAULT NULL,
  `rcon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dir` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `su_user` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cpu_limit` int(10) unsigned DEFAULT NULL,
  `ram_limit` int(10) unsigned DEFAULT NULL,
  `net_limit` int(10) unsigned DEFAULT NULL,
  `start_command` text COLLATE utf8mb4_unicode_ci,
  `stop_command` text COLLATE utf8mb4_unicode_ci,
  `force_stop_command` text COLLATE utf8mb4_unicode_ci,
  `restart_command` text COLLATE utf8mb4_unicode_ci,
  `process_active` tinyint(1) NOT NULL DEFAULT '0',
  `last_process_check` timestamp NULL DEFAULT NULL,
  `vars` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servers`
--

LOCK TABLES `servers` WRITE;
/*!40000 ALTER TABLE `servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servers_settings`
--

DROP TABLE IF EXISTS `servers_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `servers_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `servers_settings_name_server_id_unique` (`name`,`server_id`),
  KEY `servers_settings_server_id_foreign` (`server_id`),
  CONSTRAINT `servers_settings_server_id_foreign` FOREIGN KEY (`server_id`) REFERENCES `servers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servers_settings`
--

LOCK TABLES `servers_settings` WRITE;
/*!40000 ALTER TABLE `servers_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `servers_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servers_stats`
--

DROP TABLE IF EXISTS `servers_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `servers_stats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `server_id` int(10) unsigned NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ram` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cpu` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `netstat` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `drvspace` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `servers_stats_server_id_foreign` (`server_id`),
  CONSTRAINT `servers_stats_server_id_foreign` FOREIGN KEY (`server_id`) REFERENCES `servers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servers_stats`
--

LOCK TABLES `servers_stats` WRITE;
/*!40000 ALTER TABLE `servers_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `servers_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servers_tasks`
--

DROP TABLE IF EXISTS `servers_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `servers_tasks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `command` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `server_id` int(11) NOT NULL,
  `repeat` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `repeat_period` int(11) NOT NULL DEFAULT '0',
  `counter` int(10) unsigned NOT NULL DEFAULT '0',
  `execute_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `payload` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `servers_tasks_server_id_index` (`server_id`),
  KEY `servers_tasks_execute_date_index` (`execute_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servers_tasks`
--

LOCK TABLES `servers_tasks` WRITE;
/*!40000 ALTER TABLE `servers_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `servers_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servers_tasks_fails`
--

DROP TABLE IF EXISTS `servers_tasks_fails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `servers_tasks_fails` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `server_task_id` bigint(20) unsigned NOT NULL,
  `output` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `servers_tasks_fails_server_task_id_foreign` (`server_task_id`),
  CONSTRAINT `servers_tasks_fails_server_task_id_foreign` FOREIGN KEY (`server_task_id`) REFERENCES `servers_tasks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servers_tasks_fails`
--

LOCK TABLES `servers_tasks_fails` WRITE;
/*!40000 ALTER TABLE `servers_tasks_fails` DISABLE KEYS */;
/*!40000 ALTER TABLE `servers_tasks_fails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `login` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_login_unique` (`login`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'admin','admin@yousite.local','$2a$10$Fke.QmsyW3p0hEyCGXbIaeh3xkKEQwjyxH7syHdVxl68FRlho5KVq',NULL,'Admin',NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-03-02 12:20:56
