@php($title = __('client_certificates.title_create'))

@extends('layouts.main')

@section('breadcrumbs')
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="/">GameAP</a></li>
        <li class="breadcrumb-item">
            <a href="{{ route('admin.dedicated_servers.index') }}">
                {{ __('dedicated_servers.dedicated_servers') }}
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('admin.client_certificates.index') }}">
                {{ __('client_certificates.client_certificates') }}
            </a>
        </li>
        <li class="breadcrumb-item active">{{ __('client_certificates.create') }}</li>
    </ol>
@endsection

@section('content')
    @include('components.form.errors_block')

    {!! Form::open(['url' => route('admin.client_certificates.index'), 'files' => true]) !!}
        <div class="card bg-light mt-3 mb-3">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">

                        <div class="row">
                            <div class="col-md-12 mt-4 mb-3 pt-1">
                                <div class="input-group" id="serverCertificateForm">
                                    {{ Form::file('certificate', ['class' => 'form-control']) }}
                                    {{ Form::label('certificate', __('client_certificates.certificate'), ['class' => 'input-group-text']) }}

                                    @if ($errors->has('certificate'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('certificate') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>

                            <div class="col-md-6 mt-4 mb-3 pt-1">
                                <div class="input-group" id="serverCertificateForm">
                                    {{ Form::file('private_key', ['class' => 'form-control']) }}
                                    {{ Form::label('private_key', __('client_certificates.private_key'), ['class' => 'input-group-text']) }}

                                    @if ($errors->has('private_key'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('private_key') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-md-6">
                                {{ Form::bsPassword('private_key_pass') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="mb-3">
                    {{ Form::submit(__('main.create'), ['class' => 'btn btn-success']) }}
                </div>
            </div>
        </div>

    {!! Form::close() !!}

@endsection
