<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeGameModsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('game_mods', function (Blueprint $table) {
            $table->renameColumn('remote_repository', 'remote_repository_linux');
        });
        Schema::table('game_mods', function (Blueprint $table) {
            $table->renameColumn('local_repository', 'local_repository_linux');
        });
        Schema::table('game_mods', function (Blueprint $table) {
            $table->renameColumn('default_start_cmd_linux', 'start_cmd_linux');
        });
        Schema::table('game_mods', function (Blueprint $table) {
            $table->renameColumn('default_start_cmd_windows', 'start_cmd_windows');
        });

        Schema::table('game_mods', function (Blueprint $table) {
            $table->text('remote_repository_windows')->after('remote_repository_linux')->nullable();
            $table->text('local_repository_windows')->after('local_repository_linux')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('game_mods', function (Blueprint $table) {
            $table->renameColumn('remote_repository_linux', 'remote_repository');
            $table->renameColumn('local_repository_linux', 'local_repository');
            $table->renameColumn('start_cmd_linux', 'default_start_cmd_linux');
            $table->renameColumn('start_cmd_windows', 'default_start_cmd_windows');
            $table->dropColumn('remote_repository_windows');
            $table->dropColumn('local_repository_windows');
        });
    }
}
