# GameAP File Manager

![Laravel File Manager](https://raw.github.com/gameap/vue-gameap-file-manager/master/src/assets/laravel-file-manager.gif?raw=true)

**Vue.js Frontend:** [gameap/vue-gameap-file-manager](https://github.com/gameap/vue-gameap-file-manager)

## Documentation

[GameAP File Manager Docs](./docs/index.md)
* [Installation](./docs/installation.md)
* [Configuration](./docs/configuration.md)
* [Integration](./docs/integration.md)
* [Customization](./docs/customization.md)

## Features

* Frontend on Vue.js - [vue-gameap-file-manager](https://github.com/gameap/vue-gameap-file-manager)
* Work with the file system is organized by the standard means Laravel Flysystem:
  * Local, FTP, S3, Dropbox ...
  * The ability to work only with the selected disks
* Several options for displaying the file manager:
  * One-panel view
  * One-panel + Directory tree
  * Two-panel
* The minimum required set of operations:
   * Creating files
   * Creating folders
   * Copying / Cutting Folders and Files
   * Renaming
   * Uploading files (multi-upload)
   * Downloading files
   * Two modes of displaying elements - table and grid
   * Preview for images
   * Viewing images
   * Full screen mode
* More operations (v.2):
   * Audio player (mp3, ogg, wav, aac), Video player (webm, mp4) - ([Plyr](https://github.com/sampotts/plyr))
   * Code editor - ([Code Mirror](https://github.com/codemirror/codemirror))
   * Image cropper - ([Cropper.js](https://github.com/fengyuanchen/cropperjs))
   * Zip / Unzip - only for local disks
* Integration with WYSIWYG Editors:
  * CKEditor 4
* Supported locales : ru, en, ar

## Thanks

* Khalid Bj [D34DlyM4N](https://github.com/D34DlyM4N)


