<?php

/**
 * Laravel - A PHP Framework For Web Artisans
 *
 * @package  Laravel
 * @author   Taylor Otwell <taylor@laravel.com>
 */

$uri = urldecode(
    parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH)
);

// This file allows us to emulate Apache's "mod_rewrite" functionality from the
// built-in PHP web server. This provides a convenient way to test a Laravel
// application without having installed a "real" web server software here.
if ($uri !== '/' && file_exists(__DIR__.'/public'.$uri)) {
	$file = __DIR__ . '/public' . $uri;

	$pathinfo = pathinfo($file);
	
	if ($pathinfo['extension'] == 'css') {
		$mime = "text/css";
	} else if ($pathinfo['extension'] == 'js') {
		$mime = "text/javascript";
	} else {
		$mime = mime_content_type($file);
	}
	
	header('Content-Type: ' . $mime);
    echo file_get_contents(__DIR__.'/public'.$uri);
    exit;
}

require_once __DIR__.'/public/index.php';
